<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v23/services/asset_generation_service.proto

namespace Google\Ads\GoogleAds\V23\Services;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [AssetGenerationService.GenerateImages][google.ads.googleads.v23.services.AssetGenerationService.GenerateImages]
 *
 * Generated from protobuf message <code>google.ads.googleads.v23.services.GenerateImagesRequest</code>
 */
class GenerateImagesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the customer for whom the images are being generated.
     * Required.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $customer_id = '';
    /**
     * Optional. Output field types for generated images. Supported values are
     * MARKETING_IMAGE, SQUARE_MARKETING_IMAGE, PORTRAIT_MARKETING_IMAGE, and
     * TALL_PORTRAIT_MARKETING_IMAGE. All specified field types must be
     * compatible with the `advertising_channel_type` or
     * `existing_generation_context` (whichever is set). If no field types are
     * provided, images will be generated for all compatible field types.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AssetFieldTypeEnum.AssetFieldType asset_field_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $asset_field_types;
    protected $context;
    protected $generation_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $customer_id
     *           Required. The ID of the customer for whom the images are being generated.
     *           Required.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $asset_field_types
     *           Optional. Output field types for generated images. Supported values are
     *           MARKETING_IMAGE, SQUARE_MARKETING_IMAGE, PORTRAIT_MARKETING_IMAGE, and
     *           TALL_PORTRAIT_MARKETING_IMAGE. All specified field types must be
     *           compatible with the `advertising_channel_type` or
     *           `existing_generation_context` (whichever is set). If no field types are
     *           provided, images will be generated for all compatible field types.
     *     @type int $advertising_channel_type
     *           Optional. The advertising channel type for which the images are being
     *           generated. This field is required if `existing_generation_context` is not
     *           provided. Supported channel types include SEARCH, PERFORMANCE_MAX,
     *           DISPLAY, and DEMAND_GEN.
     *     @type \Google\Ads\GoogleAds\V23\Services\FinalUrlImageGenerationInput $final_url_generation
     *           Optional. Generate images from a final url.
     *     @type \Google\Ads\GoogleAds\V23\Services\FreeformImageGenerationInput $freeform_generation
     *           Optional. Generate images from a freeform prompt.
     *     @type \Google\Ads\GoogleAds\V23\Services\ProductRecontextGenerationImageInput $product_recontext_generation
     *           Optional. Generate new images by recontextualizing existing product
     *           images.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V23\Services\AssetGenerationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the customer for whom the images are being generated.
     * Required.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * Required. The ID of the customer for whom the images are being generated.
     * Required.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_id = $var;

        return $this;
    }

    /**
     * Optional. Output field types for generated images. Supported values are
     * MARKETING_IMAGE, SQUARE_MARKETING_IMAGE, PORTRAIT_MARKETING_IMAGE, and
     * TALL_PORTRAIT_MARKETING_IMAGE. All specified field types must be
     * compatible with the `advertising_channel_type` or
     * `existing_generation_context` (whichever is set). If no field types are
     * provided, images will be generated for all compatible field types.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AssetFieldTypeEnum.AssetFieldType asset_field_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAssetFieldTypes()
    {
        return $this->asset_field_types;
    }

    /**
     * Optional. Output field types for generated images. Supported values are
     * MARKETING_IMAGE, SQUARE_MARKETING_IMAGE, PORTRAIT_MARKETING_IMAGE, and
     * TALL_PORTRAIT_MARKETING_IMAGE. All specified field types must be
     * compatible with the `advertising_channel_type` or
     * `existing_generation_context` (whichever is set). If no field types are
     * provided, images will be generated for all compatible field types.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AssetFieldTypeEnum.AssetFieldType asset_field_types = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAssetFieldTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Ads\GoogleAds\V23\Enums\AssetFieldTypeEnum\AssetFieldType::class);
        $this->asset_field_types = $arr;

        return $this;
    }

    /**
     * Optional. The advertising channel type for which the images are being
     * generated. This field is required if `existing_generation_context` is not
     * provided. Supported channel types include SEARCH, PERFORMANCE_MAX,
     * DISPLAY, and DEMAND_GEN.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAdvertisingChannelType()
    {
        return $this->readOneof(2);
    }

    public function hasAdvertisingChannelType()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. The advertising channel type for which the images are being
     * generated. This field is required if `existing_generation_context` is not
     * provided. Supported channel types include SEARCH, PERFORMANCE_MAX,
     * DISPLAY, and DEMAND_GEN.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAdvertisingChannelType($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V23\Enums\AdvertisingChannelTypeEnum\AdvertisingChannelType::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. Generate images from a final url.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.FinalUrlImageGenerationInput final_url_generation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V23\Services\FinalUrlImageGenerationInput|null
     */
    public function getFinalUrlGeneration()
    {
        return $this->readOneof(5);
    }

    public function hasFinalUrlGeneration()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. Generate images from a final url.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.FinalUrlImageGenerationInput final_url_generation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V23\Services\FinalUrlImageGenerationInput $var
     * @return $this
     */
    public function setFinalUrlGeneration($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Services\FinalUrlImageGenerationInput::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Optional. Generate images from a freeform prompt.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.FreeformImageGenerationInput freeform_generation = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V23\Services\FreeformImageGenerationInput|null
     */
    public function getFreeformGeneration()
    {
        return $this->readOneof(6);
    }

    public function hasFreeformGeneration()
    {
        return $this->hasOneof(6);
    }

    /**
     * Optional. Generate images from a freeform prompt.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.FreeformImageGenerationInput freeform_generation = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V23\Services\FreeformImageGenerationInput $var
     * @return $this
     */
    public function setFreeformGeneration($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Services\FreeformImageGenerationInput::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Optional. Generate new images by recontextualizing existing product
     * images.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.ProductRecontextGenerationImageInput product_recontext_generation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V23\Services\ProductRecontextGenerationImageInput|null
     */
    public function getProductRecontextGeneration()
    {
        return $this->readOneof(7);
    }

    public function hasProductRecontextGeneration()
    {
        return $this->hasOneof(7);
    }

    /**
     * Optional. Generate new images by recontextualizing existing product
     * images.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.services.ProductRecontextGenerationImageInput product_recontext_generation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V23\Services\ProductRecontextGenerationImageInput $var
     * @return $this
     */
    public function setProductRecontextGeneration($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Services\ProductRecontextGenerationImageInput::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getContext()
    {
        return $this->whichOneof("context");
    }

    /**
     * @return string
     */
    public function getGenerationType()
    {
        return $this->whichOneof("generation_type");
    }

}

