<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v23/services/audience_insights_service.proto

namespace Google\Ads\GoogleAds\V23\Services;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [AudienceInsightsService.GenerateAudienceOverlapInsights][google.ads.googleads.v23.services.AudienceInsightsService.GenerateAudienceOverlapInsights].
 *
 * Generated from protobuf message <code>google.ads.googleads.v23.services.GenerateAudienceOverlapInsightsRequest</code>
 */
class GenerateAudienceOverlapInsightsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the customer.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $customer_id = '';
    /**
     * Required. The country in which to calculate the sizes and overlaps of
     * audiences.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.LocationInfo country_location = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $country_location = null;
    /**
     * Required. The audience attribute that should be intersected with all other
     * eligible audiences.  This must be an Affinity or In-Market UserInterest, an
     * AgeRange or a Gender.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AudienceInsightsAttribute primary_attribute = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $primary_attribute = null;
    /**
     * Required. The types of attributes of which to calculate the overlap with
     * the primary_attribute. The values must be a subset of
     * AFFINITY_USER_INTEREST, IN_MARKET_USER_INTEREST, AGE_RANGE and GENDER.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $dimensions;
    /**
     * The name of the customer being planned for.  This is a user-defined value.
     *
     * Generated from protobuf field <code>string customer_insights_group = 5;</code>
     */
    protected $customer_insights_group = '';
    /**
     * Optional. Additional information on the application issuing the request.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AdditionalApplicationInfo insights_application_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $insights_application_info = null;

    /**
     * @param string                                                     $customerId       Required. The ID of the customer.
     * @param \Google\Ads\GoogleAds\V23\Common\LocationInfo              $countryLocation  Required. The country in which to calculate the sizes and overlaps of
     *                                                                                     audiences.
     * @param \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute $primaryAttribute Required. The audience attribute that should be intersected with all other
     *                                                                                     eligible audiences.  This must be an Affinity or In-Market UserInterest, an
     *                                                                                     AgeRange or a Gender.
     * @param int[]                                                      $dimensions       Required. The types of attributes of which to calculate the overlap with
     *                                                                                     the primary_attribute. The values must be a subset of
     *                                                                                     AFFINITY_USER_INTEREST, IN_MARKET_USER_INTEREST, AGE_RANGE and GENDER.
     *                                                                                     For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V23\Enums\AudienceInsightsDimensionEnum\AudienceInsightsDimension}
     *
     * @return \Google\Ads\GoogleAds\V23\Services\GenerateAudienceOverlapInsightsRequest
     *
     * @experimental
     */
    public static function build(string $customerId, \Google\Ads\GoogleAds\V23\Common\LocationInfo $countryLocation, \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute $primaryAttribute, array $dimensions): self
    {
        return (new self())
            ->setCustomerId($customerId)
            ->setCountryLocation($countryLocation)
            ->setPrimaryAttribute($primaryAttribute)
            ->setDimensions($dimensions);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $customer_id
     *           Required. The ID of the customer.
     *     @type \Google\Ads\GoogleAds\V23\Common\LocationInfo $country_location
     *           Required. The country in which to calculate the sizes and overlaps of
     *           audiences.
     *     @type \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute $primary_attribute
     *           Required. The audience attribute that should be intersected with all other
     *           eligible audiences.  This must be an Affinity or In-Market UserInterest, an
     *           AgeRange or a Gender.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $dimensions
     *           Required. The types of attributes of which to calculate the overlap with
     *           the primary_attribute. The values must be a subset of
     *           AFFINITY_USER_INTEREST, IN_MARKET_USER_INTEREST, AGE_RANGE and GENDER.
     *     @type string $customer_insights_group
     *           The name of the customer being planned for.  This is a user-defined value.
     *     @type \Google\Ads\GoogleAds\V23\Common\AdditionalApplicationInfo $insights_application_info
     *           Optional. Additional information on the application issuing the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V23\Services\AudienceInsightsService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the customer.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * Required. The ID of the customer.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_id = $var;

        return $this;
    }

    /**
     * Required. The country in which to calculate the sizes and overlaps of
     * audiences.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.LocationInfo country_location = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Ads\GoogleAds\V23\Common\LocationInfo|null
     */
    public function getCountryLocation()
    {
        return $this->country_location;
    }

    public function hasCountryLocation()
    {
        return isset($this->country_location);
    }

    public function clearCountryLocation()
    {
        unset($this->country_location);
    }

    /**
     * Required. The country in which to calculate the sizes and overlaps of
     * audiences.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.LocationInfo country_location = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Ads\GoogleAds\V23\Common\LocationInfo $var
     * @return $this
     */
    public function setCountryLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Common\LocationInfo::class);
        $this->country_location = $var;

        return $this;
    }

    /**
     * Required. The audience attribute that should be intersected with all other
     * eligible audiences.  This must be an Affinity or In-Market UserInterest, an
     * AgeRange or a Gender.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AudienceInsightsAttribute primary_attribute = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute|null
     */
    public function getPrimaryAttribute()
    {
        return $this->primary_attribute;
    }

    public function hasPrimaryAttribute()
    {
        return isset($this->primary_attribute);
    }

    public function clearPrimaryAttribute()
    {
        unset($this->primary_attribute);
    }

    /**
     * Required. The audience attribute that should be intersected with all other
     * eligible audiences.  This must be an Affinity or In-Market UserInterest, an
     * AgeRange or a Gender.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AudienceInsightsAttribute primary_attribute = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute $var
     * @return $this
     */
    public function setPrimaryAttribute($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Common\AudienceInsightsAttribute::class);
        $this->primary_attribute = $var;

        return $this;
    }

    /**
     * Required. The types of attributes of which to calculate the overlap with
     * the primary_attribute. The values must be a subset of
     * AFFINITY_USER_INTEREST, IN_MARKET_USER_INTEREST, AGE_RANGE and GENDER.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * Required. The types of attributes of which to calculate the overlap with
     * the primary_attribute. The values must be a subset of
     * AFFINITY_USER_INTEREST, IN_MARKET_USER_INTEREST, AGE_RANGE and GENDER.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v23.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Ads\GoogleAds\V23\Enums\AudienceInsightsDimensionEnum\AudienceInsightsDimension::class);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * The name of the customer being planned for.  This is a user-defined value.
     *
     * Generated from protobuf field <code>string customer_insights_group = 5;</code>
     * @return string
     */
    public function getCustomerInsightsGroup()
    {
        return $this->customer_insights_group;
    }

    /**
     * The name of the customer being planned for.  This is a user-defined value.
     *
     * Generated from protobuf field <code>string customer_insights_group = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerInsightsGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_insights_group = $var;

        return $this;
    }

    /**
     * Optional. Additional information on the application issuing the request.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AdditionalApplicationInfo insights_application_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V23\Common\AdditionalApplicationInfo|null
     */
    public function getInsightsApplicationInfo()
    {
        return $this->insights_application_info;
    }

    public function hasInsightsApplicationInfo()
    {
        return isset($this->insights_application_info);
    }

    public function clearInsightsApplicationInfo()
    {
        unset($this->insights_application_info);
    }

    /**
     * Optional. Additional information on the application issuing the request.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v23.common.AdditionalApplicationInfo insights_application_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V23\Common\AdditionalApplicationInfo $var
     * @return $this
     */
    public function setInsightsApplicationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V23\Common\AdditionalApplicationInfo::class);
        $this->insights_application_info = $var;

        return $this;
    }

}

