<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v23/services/incentive_service.proto

namespace Google\Ads\GoogleAds\V23\Services;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for applying an incentive.
 *
 * Generated from protobuf message <code>google.ads.googleads.v23.services.ApplyIncentiveRequest</code>
 */
class ApplyIncentiveRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The incentive ID of this incentive. This is used to identify which
     * incentive is selected by the user in the CYO flow.
     *
     * Generated from protobuf field <code>optional int64 selected_incentive_id = 1;</code>
     */
    protected $selected_incentive_id = null;
    /**
     * The customer ID of the account that the incentive is being applied to.
     *
     * Generated from protobuf field <code>optional string customer_id = 2;</code>
     */
    protected $customer_id = null;
    /**
     * Required. User's country code.
     * Required. This field must be equal to the Google Ads account's billing
     * country. Incentive eligibility, terms of service, and reward values are
     * often country-specific. This country code is used to ensure the selected
     * incentive is applicable to the user.
     * Possible country codes:
     * https://developers.google.com/google-ads/api/data/codes-formats#country_codes
     *
     * Generated from protobuf field <code>optional string country_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $country_code = null;

    /**
     * @param string $countryCode Required. User's country code.
     *                            Required. This field must be equal to the Google Ads account's billing
     *                            country. Incentive eligibility, terms of service, and reward values are
     *                            often country-specific. This country code is used to ensure the selected
     *                            incentive is applicable to the user.
     *                            Possible country codes:
     *                            https://developers.google.com/google-ads/api/data/codes-formats#country_codes
     *
     * @return \Google\Ads\GoogleAds\V23\Services\ApplyIncentiveRequest
     *
     * @experimental
     */
    public static function build(string $countryCode): self
    {
        return (new self())
            ->setCountryCode($countryCode);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $selected_incentive_id
     *           The incentive ID of this incentive. This is used to identify which
     *           incentive is selected by the user in the CYO flow.
     *     @type string $customer_id
     *           The customer ID of the account that the incentive is being applied to.
     *     @type string $country_code
     *           Required. User's country code.
     *           Required. This field must be equal to the Google Ads account's billing
     *           country. Incentive eligibility, terms of service, and reward values are
     *           often country-specific. This country code is used to ensure the selected
     *           incentive is applicable to the user.
     *           Possible country codes:
     *           https://developers.google.com/google-ads/api/data/codes-formats#country_codes
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V23\Services\IncentiveService::initOnce();
        parent::__construct($data);
    }

    /**
     * The incentive ID of this incentive. This is used to identify which
     * incentive is selected by the user in the CYO flow.
     *
     * Generated from protobuf field <code>optional int64 selected_incentive_id = 1;</code>
     * @return int|string
     */
    public function getSelectedIncentiveId()
    {
        return isset($this->selected_incentive_id) ? $this->selected_incentive_id : 0;
    }

    public function hasSelectedIncentiveId()
    {
        return isset($this->selected_incentive_id);
    }

    public function clearSelectedIncentiveId()
    {
        unset($this->selected_incentive_id);
    }

    /**
     * The incentive ID of this incentive. This is used to identify which
     * incentive is selected by the user in the CYO flow.
     *
     * Generated from protobuf field <code>optional int64 selected_incentive_id = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSelectedIncentiveId($var)
    {
        GPBUtil::checkInt64($var);
        $this->selected_incentive_id = $var;

        return $this;
    }

    /**
     * The customer ID of the account that the incentive is being applied to.
     *
     * Generated from protobuf field <code>optional string customer_id = 2;</code>
     * @return string
     */
    public function getCustomerId()
    {
        return isset($this->customer_id) ? $this->customer_id : '';
    }

    public function hasCustomerId()
    {
        return isset($this->customer_id);
    }

    public function clearCustomerId()
    {
        unset($this->customer_id);
    }

    /**
     * The customer ID of the account that the incentive is being applied to.
     *
     * Generated from protobuf field <code>optional string customer_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_id = $var;

        return $this;
    }

    /**
     * Required. User's country code.
     * Required. This field must be equal to the Google Ads account's billing
     * country. Incentive eligibility, terms of service, and reward values are
     * often country-specific. This country code is used to ensure the selected
     * incentive is applicable to the user.
     * Possible country codes:
     * https://developers.google.com/google-ads/api/data/codes-formats#country_codes
     *
     * Generated from protobuf field <code>optional string country_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCountryCode()
    {
        return isset($this->country_code) ? $this->country_code : '';
    }

    public function hasCountryCode()
    {
        return isset($this->country_code);
    }

    public function clearCountryCode()
    {
        unset($this->country_code);
    }

    /**
     * Required. User's country code.
     * Required. This field must be equal to the Google Ads account's billing
     * country. Incentive eligibility, terms of service, and reward values are
     * often country-specific. This country code is used to ensure the selected
     * incentive is applicable to the user.
     * Possible country codes:
     * https://developers.google.com/google-ads/api/data/codes-formats#country_codes
     *
     * Generated from protobuf field <code>optional string country_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCountryCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->country_code = $var;

        return $this;
    }

}

