<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v23/resources/display_keyword_view.proto

namespace Google\Ads\GoogleAds\V23\Resources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A display keyword view.
 * Provides performance data for keywords used in Display Network campaigns.
 * This view lets you analyze how your display keywords are performing
 * across various segments.
 * This view is primarily used to track the effectiveness of keyword targeting
 * within your Display campaigns. To understand which network the metrics apply
 * to, you can select the `segments.ad_network_type` field in your query. This
 * field will segment the data by networks such as the Google Display Network,
 * YouTube, Gmail, and so on.
 * You can select fields from this resource along with metrics like impressions,
 * clicks, and conversions to gauge performance. Attributed resources like
 * `ad_group` and `campaign` can also be selected without segmenting metrics.
 *
 * Generated from protobuf message <code>google.ads.googleads.v23.resources.DisplayKeywordView</code>
 */
class DisplayKeywordView extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the display keyword view.
     * Display Keyword view resource names have the form:
     * `customers/{customer_id}/displayKeywordViews/{ad_group_id}~{criterion_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $resource_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           Output only. The resource name of the display keyword view.
     *           Display Keyword view resource names have the form:
     *           `customers/{customer_id}/displayKeywordViews/{ad_group_id}~{criterion_id}`
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V23\Resources\DisplayKeywordView::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the display keyword view.
     * Display Keyword view resource names have the form:
     * `customers/{customer_id}/displayKeywordViews/{ad_group_id}~{criterion_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Output only. The resource name of the display keyword view.
     * Display Keyword view resource names have the form:
     * `customers/{customer_id}/displayKeywordViews/{ad_group_id}~{criterion_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

}

