<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v22/resources/local_services_employee.proto

namespace Google\Ads\GoogleAds\V22\Resources;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A local services employee resource.
 *
 * Generated from protobuf message <code>google.ads.googleads.v22.resources.LocalServicesEmployee</code>
 */
class LocalServicesEmployee extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The resource name of the Local Services Verification.
     * Local Services Verification resource names have the form:
     * `customers/{customer_id}/localServicesEmployees/{gls_employee_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $resource_name = '';
    /**
     * Output only. The ID of the employee.
     *
     * Generated from protobuf field <code>optional int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $id = null;
    /**
     * Output only. Timestamp of employee creation.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     *
     * Generated from protobuf field <code>string creation_date_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creation_date_time = '';
    /**
     * Output only. Employee status, such as DELETED or ENABLED.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeStatusEnum.LocalServicesEmployeeStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = 0;
    /**
     * Output only. Employee type.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeTypeEnum.LocalServicesEmployeeType type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $type = 0;
    /**
     * Output only. A list of degrees this employee has obtained, and wants to
     * feature.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.UniversityDegree university_degrees = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $university_degrees;
    /**
     * Output only. The institutions where the employee has completed their
     * residency.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Residency residencies = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $residencies;
    /**
     * Output only. The institutions where the employee has completed their
     * fellowship.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Fellowship fellowships = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $fellowships;
    /**
     * Output only. Job title for this employee, such as "Senior partner" in legal
     * verticals.
     *
     * Generated from protobuf field <code>optional string job_title = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $job_title = null;
    /**
     * Output only. The year that this employee started practicing in this field.
     *
     * Generated from protobuf field <code>optional int32 year_started_practicing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $year_started_practicing = null;
    /**
     * Output only. Languages that the employee speaks, represented as language
     * tags from https://developers.google.com/admin-sdk/directory/v1/languages
     *
     * Generated from protobuf field <code>repeated string languages_spoken = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $languages_spoken;
    /**
     * Output only. Category of the employee. A list of Local Services category
     * IDs can be found at
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids.
     *
     * Generated from protobuf field <code>repeated string category_ids = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $category_ids;
    /**
     * Output only. NPI id associated with the employee.
     *
     * Generated from protobuf field <code>optional string national_provider_id_number = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $national_provider_id_number = null;
    /**
     * Output only. Email address of the employee.
     *
     * Generated from protobuf field <code>optional string email_address = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $email_address = null;
    /**
     * Output only. First name of the employee.
     *
     * Generated from protobuf field <code>optional string first_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $first_name = null;
    /**
     * Output only. Middle name of the employee.
     *
     * Generated from protobuf field <code>optional string middle_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $middle_name = null;
    /**
     * Output only. Last name of the employee.
     *
     * Generated from protobuf field <code>optional string last_name = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_name = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           Immutable. The resource name of the Local Services Verification.
     *           Local Services Verification resource names have the form:
     *           `customers/{customer_id}/localServicesEmployees/{gls_employee_id}`
     *     @type int|string $id
     *           Output only. The ID of the employee.
     *     @type string $creation_date_time
     *           Output only. Timestamp of employee creation.
     *           The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     *           Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     *     @type int $status
     *           Output only. Employee status, such as DELETED or ENABLED.
     *     @type int $type
     *           Output only. Employee type.
     *     @type array<\Google\Ads\GoogleAds\V22\Resources\UniversityDegree>|\Google\Protobuf\Internal\RepeatedField $university_degrees
     *           Output only. A list of degrees this employee has obtained, and wants to
     *           feature.
     *     @type array<\Google\Ads\GoogleAds\V22\Resources\Residency>|\Google\Protobuf\Internal\RepeatedField $residencies
     *           Output only. The institutions where the employee has completed their
     *           residency.
     *     @type array<\Google\Ads\GoogleAds\V22\Resources\Fellowship>|\Google\Protobuf\Internal\RepeatedField $fellowships
     *           Output only. The institutions where the employee has completed their
     *           fellowship.
     *     @type string $job_title
     *           Output only. Job title for this employee, such as "Senior partner" in legal
     *           verticals.
     *     @type int $year_started_practicing
     *           Output only. The year that this employee started practicing in this field.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $languages_spoken
     *           Output only. Languages that the employee speaks, represented as language
     *           tags from https://developers.google.com/admin-sdk/directory/v1/languages
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $category_ids
     *           Output only. Category of the employee. A list of Local Services category
     *           IDs can be found at
     *           https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids.
     *     @type string $national_provider_id_number
     *           Output only. NPI id associated with the employee.
     *     @type string $email_address
     *           Output only. Email address of the employee.
     *     @type string $first_name
     *           Output only. First name of the employee.
     *     @type string $middle_name
     *           Output only. Middle name of the employee.
     *     @type string $last_name
     *           Output only. Last name of the employee.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V22\Resources\LocalServicesEmployee::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The resource name of the Local Services Verification.
     * Local Services Verification resource names have the form:
     * `customers/{customer_id}/localServicesEmployees/{gls_employee_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * Immutable. The resource name of the Local Services Verification.
     * Local Services Verification resource names have the form:
     * `customers/{customer_id}/localServicesEmployees/{gls_employee_id}`
     *
     * Generated from protobuf field <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * Output only. The ID of the employee.
     *
     * Generated from protobuf field <code>optional int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Output only. The ID of the employee.
     *
     * Generated from protobuf field <code>optional int64 id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkInt64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Output only. Timestamp of employee creation.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     *
     * Generated from protobuf field <code>string creation_date_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCreationDateTime()
    {
        return $this->creation_date_time;
    }

    /**
     * Output only. Timestamp of employee creation.
     * The format is "YYYY-MM-DD HH:MM:SS" in the Google Ads account's timezone.
     * Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
     *
     * Generated from protobuf field <code>string creation_date_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCreationDateTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_date_time = $var;

        return $this;
    }

    /**
     * Output only. Employee status, such as DELETED or ENABLED.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeStatusEnum.LocalServicesEmployeeStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. Employee status, such as DELETED or ENABLED.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeStatusEnum.LocalServicesEmployeeStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V22\Enums\LocalServicesEmployeeStatusEnum\LocalServicesEmployeeStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. Employee type.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeTypeEnum.LocalServicesEmployeeType type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. Employee type.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v22.enums.LocalServicesEmployeeTypeEnum.LocalServicesEmployeeType type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V22\Enums\LocalServicesEmployeeTypeEnum\LocalServicesEmployeeType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Output only. A list of degrees this employee has obtained, and wants to
     * feature.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.UniversityDegree university_degrees = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUniversityDegrees()
    {
        return $this->university_degrees;
    }

    /**
     * Output only. A list of degrees this employee has obtained, and wants to
     * feature.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.UniversityDegree university_degrees = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\GoogleAds\V22\Resources\UniversityDegree>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUniversityDegrees($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V22\Resources\UniversityDegree::class);
        $this->university_degrees = $arr;

        return $this;
    }

    /**
     * Output only. The institutions where the employee has completed their
     * residency.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Residency residencies = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResidencies()
    {
        return $this->residencies;
    }

    /**
     * Output only. The institutions where the employee has completed their
     * residency.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Residency residencies = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\GoogleAds\V22\Resources\Residency>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResidencies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V22\Resources\Residency::class);
        $this->residencies = $arr;

        return $this;
    }

    /**
     * Output only. The institutions where the employee has completed their
     * fellowship.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Fellowship fellowships = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFellowships()
    {
        return $this->fellowships;
    }

    /**
     * Output only. The institutions where the employee has completed their
     * fellowship.
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v22.resources.Fellowship fellowships = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Ads\GoogleAds\V22\Resources\Fellowship>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFellowships($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V22\Resources\Fellowship::class);
        $this->fellowships = $arr;

        return $this;
    }

    /**
     * Output only. Job title for this employee, such as "Senior partner" in legal
     * verticals.
     *
     * Generated from protobuf field <code>optional string job_title = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getJobTitle()
    {
        return isset($this->job_title) ? $this->job_title : '';
    }

    public function hasJobTitle()
    {
        return isset($this->job_title);
    }

    public function clearJobTitle()
    {
        unset($this->job_title);
    }

    /**
     * Output only. Job title for this employee, such as "Senior partner" in legal
     * verticals.
     *
     * Generated from protobuf field <code>optional string job_title = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setJobTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->job_title = $var;

        return $this;
    }

    /**
     * Output only. The year that this employee started practicing in this field.
     *
     * Generated from protobuf field <code>optional int32 year_started_practicing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getYearStartedPracticing()
    {
        return isset($this->year_started_practicing) ? $this->year_started_practicing : 0;
    }

    public function hasYearStartedPracticing()
    {
        return isset($this->year_started_practicing);
    }

    public function clearYearStartedPracticing()
    {
        unset($this->year_started_practicing);
    }

    /**
     * Output only. The year that this employee started practicing in this field.
     *
     * Generated from protobuf field <code>optional int32 year_started_practicing = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setYearStartedPracticing($var)
    {
        GPBUtil::checkInt32($var);
        $this->year_started_practicing = $var;

        return $this;
    }

    /**
     * Output only. Languages that the employee speaks, represented as language
     * tags from https://developers.google.com/admin-sdk/directory/v1/languages
     *
     * Generated from protobuf field <code>repeated string languages_spoken = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLanguagesSpoken()
    {
        return $this->languages_spoken;
    }

    /**
     * Output only. Languages that the employee speaks, represented as language
     * tags from https://developers.google.com/admin-sdk/directory/v1/languages
     *
     * Generated from protobuf field <code>repeated string languages_spoken = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLanguagesSpoken($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->languages_spoken = $arr;

        return $this;
    }

    /**
     * Output only. Category of the employee. A list of Local Services category
     * IDs can be found at
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids.
     *
     * Generated from protobuf field <code>repeated string category_ids = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCategoryIds()
    {
        return $this->category_ids;
    }

    /**
     * Output only. Category of the employee. A list of Local Services category
     * IDs can be found at
     * https://developers.google.com/google-ads/api/data/codes-formats#local_services_ids.
     *
     * Generated from protobuf field <code>repeated string category_ids = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCategoryIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->category_ids = $arr;

        return $this;
    }

    /**
     * Output only. NPI id associated with the employee.
     *
     * Generated from protobuf field <code>optional string national_provider_id_number = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getNationalProviderIdNumber()
    {
        return isset($this->national_provider_id_number) ? $this->national_provider_id_number : '';
    }

    public function hasNationalProviderIdNumber()
    {
        return isset($this->national_provider_id_number);
    }

    public function clearNationalProviderIdNumber()
    {
        unset($this->national_provider_id_number);
    }

    /**
     * Output only. NPI id associated with the employee.
     *
     * Generated from protobuf field <code>optional string national_provider_id_number = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setNationalProviderIdNumber($var)
    {
        GPBUtil::checkString($var, True);
        $this->national_provider_id_number = $var;

        return $this;
    }

    /**
     * Output only. Email address of the employee.
     *
     * Generated from protobuf field <code>optional string email_address = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEmailAddress()
    {
        return isset($this->email_address) ? $this->email_address : '';
    }

    public function hasEmailAddress()
    {
        return isset($this->email_address);
    }

    public function clearEmailAddress()
    {
        unset($this->email_address);
    }

    /**
     * Output only. Email address of the employee.
     *
     * Generated from protobuf field <code>optional string email_address = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEmailAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->email_address = $var;

        return $this;
    }

    /**
     * Output only. First name of the employee.
     *
     * Generated from protobuf field <code>optional string first_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getFirstName()
    {
        return isset($this->first_name) ? $this->first_name : '';
    }

    public function hasFirstName()
    {
        return isset($this->first_name);
    }

    public function clearFirstName()
    {
        unset($this->first_name);
    }

    /**
     * Output only. First name of the employee.
     *
     * Generated from protobuf field <code>optional string first_name = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setFirstName($var)
    {
        GPBUtil::checkString($var, True);
        $this->first_name = $var;

        return $this;
    }

    /**
     * Output only. Middle name of the employee.
     *
     * Generated from protobuf field <code>optional string middle_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getMiddleName()
    {
        return isset($this->middle_name) ? $this->middle_name : '';
    }

    public function hasMiddleName()
    {
        return isset($this->middle_name);
    }

    public function clearMiddleName()
    {
        unset($this->middle_name);
    }

    /**
     * Output only. Middle name of the employee.
     *
     * Generated from protobuf field <code>optional string middle_name = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setMiddleName($var)
    {
        GPBUtil::checkString($var, True);
        $this->middle_name = $var;

        return $this;
    }

    /**
     * Output only. Last name of the employee.
     *
     * Generated from protobuf field <code>optional string last_name = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastName()
    {
        return isset($this->last_name) ? $this->last_name : '';
    }

    public function hasLastName()
    {
        return isset($this->last_name);
    }

    public function clearLastName()
    {
        unset($this->last_name);
    }

    /**
     * Output only. Last name of the employee.
     *
     * Generated from protobuf field <code>optional string last_name = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastName($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_name = $var;

        return $this;
    }

}

