<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v22/resources/campaign.proto

namespace Google\Ads\GoogleAds\V22\Resources\Campaign;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings for AI Max in search campaigns.
 *
 * Generated from protobuf message <code>google.ads.googleads.v22.resources.Campaign.AiMaxSetting</code>
 */
class AiMaxSetting extends \Google\Protobuf\Internal\Message
{
    /**
     * Controls whether or not AI Max features are served for this campaign.
     * Individual AI Max features are enabled or disabled by their respective
     * settings. But if enable_ai_max is set to false or cleared, then no AI
     * Max features will serve for this campaign, regardless of the other
     * settings.
     * Search Term Matching is enabled by default when AI Max is enabled, and
     * can be disabled at the ad group level.
     *
     * Generated from protobuf field <code>optional bool enable_ai_max = 1;</code>
     */
    protected $enable_ai_max = null;
    /**
     * Output only. Indicates whether a search campaign has adopted AI Max
     * before, and is required to have AI Max enabled to adopt campaign-level
     * text asset automation and brand list targeting in all API versions.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v22.resources.Campaign.AiMaxSetting.AiMaxBundlingRequired bundling_required = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $bundling_required = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_ai_max
     *           Controls whether or not AI Max features are served for this campaign.
     *           Individual AI Max features are enabled or disabled by their respective
     *           settings. But if enable_ai_max is set to false or cleared, then no AI
     *           Max features will serve for this campaign, regardless of the other
     *           settings.
     *           Search Term Matching is enabled by default when AI Max is enabled, and
     *           can be disabled at the ad group level.
     *     @type int $bundling_required
     *           Output only. Indicates whether a search campaign has adopted AI Max
     *           before, and is required to have AI Max enabled to adopt campaign-level
     *           text asset automation and brand list targeting in all API versions.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V22\Resources\Campaign::initOnce();
        parent::__construct($data);
    }

    /**
     * Controls whether or not AI Max features are served for this campaign.
     * Individual AI Max features are enabled or disabled by their respective
     * settings. But if enable_ai_max is set to false or cleared, then no AI
     * Max features will serve for this campaign, regardless of the other
     * settings.
     * Search Term Matching is enabled by default when AI Max is enabled, and
     * can be disabled at the ad group level.
     *
     * Generated from protobuf field <code>optional bool enable_ai_max = 1;</code>
     * @return bool
     */
    public function getEnableAiMax()
    {
        return isset($this->enable_ai_max) ? $this->enable_ai_max : false;
    }

    public function hasEnableAiMax()
    {
        return isset($this->enable_ai_max);
    }

    public function clearEnableAiMax()
    {
        unset($this->enable_ai_max);
    }

    /**
     * Controls whether or not AI Max features are served for this campaign.
     * Individual AI Max features are enabled or disabled by their respective
     * settings. But if enable_ai_max is set to false or cleared, then no AI
     * Max features will serve for this campaign, regardless of the other
     * settings.
     * Search Term Matching is enabled by default when AI Max is enabled, and
     * can be disabled at the ad group level.
     *
     * Generated from protobuf field <code>optional bool enable_ai_max = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableAiMax($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_ai_max = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether a search campaign has adopted AI Max
     * before, and is required to have AI Max enabled to adopt campaign-level
     * text asset automation and brand list targeting in all API versions.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v22.resources.Campaign.AiMaxSetting.AiMaxBundlingRequired bundling_required = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getBundlingRequired()
    {
        return isset($this->bundling_required) ? $this->bundling_required : 0;
    }

    public function hasBundlingRequired()
    {
        return isset($this->bundling_required);
    }

    public function clearBundlingRequired()
    {
        unset($this->bundling_required);
    }

    /**
     * Output only. Indicates whether a search campaign has adopted AI Max
     * before, and is required to have AI Max enabled to adopt campaign-level
     * text asset automation and brand list targeting in all API versions.
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v22.resources.Campaign.AiMaxSetting.AiMaxBundlingRequired bundling_required = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setBundlingRequired($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V22\Resources\Campaign\AiMaxSetting\AiMaxBundlingRequired::class);
        $this->bundling_required = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AiMaxSetting::class, \Google\Ads\GoogleAds\V22\Resources\Campaign_AiMaxSetting::class);

