<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v21/services/campaign_service.proto

namespace Google\Ads\GoogleAds\V21\Services;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A single enable operation of a campaign.
 *
 * Generated from protobuf message <code>google.ads.googleads.v21.services.EnableOperation</code>
 */
class EnableOperation extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the campaign to enable.
     *
     * Generated from protobuf field <code>string campaign = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $campaign = '';
    /**
     * Required. The switch to automatically populate top-performing brand assets.
     * This field is required. If true, top-performing brand assets will be
     * automatically populated. If false, the brand_assets field is required.
     *
     * Generated from protobuf field <code>bool auto_populate_brand_assets = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $auto_populate_brand_assets = false;
    /**
     * Optional. The brand assets linked to the campaign. This field is required
     * when the value of auto_populate_brand_assets is false.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v21.services.BrandCampaignAssets brand_assets = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $brand_assets = null;
    /**
     * Optional. The domain of the final uri.
     *
     * Generated from protobuf field <code>string final_uri_domain = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $final_uri_domain = '';
    /**
     * Optional. Hex code representation of the main brand color, for example
     * #00ff00. main_color is required when accent color is specified.
     *
     * Generated from protobuf field <code>string main_color = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $main_color = '';
    /**
     * Optional. Hex code representation of the accent brand color, for example
     * #00ff00. accent_color is required when main_color is specified.
     *
     * Generated from protobuf field <code>string accent_color = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $accent_color = '';
    /**
     * Optional. The font family is specified as a string, and must be one of the
     * following: "Open Sans", "Roboto", "Roboto Slab", "Montserrat", "Poppins",
     * "Lato", "Oswald", or "Playfair Display".
     *
     * Generated from protobuf field <code>string font_family = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $font_family = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $campaign
     *           Required. The resource name of the campaign to enable.
     *     @type bool $auto_populate_brand_assets
     *           Required. The switch to automatically populate top-performing brand assets.
     *           This field is required. If true, top-performing brand assets will be
     *           automatically populated. If false, the brand_assets field is required.
     *     @type \Google\Ads\GoogleAds\V21\Services\BrandCampaignAssets $brand_assets
     *           Optional. The brand assets linked to the campaign. This field is required
     *           when the value of auto_populate_brand_assets is false.
     *     @type string $final_uri_domain
     *           Optional. The domain of the final uri.
     *     @type string $main_color
     *           Optional. Hex code representation of the main brand color, for example
     *           #00ff00. main_color is required when accent color is specified.
     *     @type string $accent_color
     *           Optional. Hex code representation of the accent brand color, for example
     *           #00ff00. accent_color is required when main_color is specified.
     *     @type string $font_family
     *           Optional. The font family is specified as a string, and must be one of the
     *           following: "Open Sans", "Roboto", "Roboto Slab", "Montserrat", "Poppins",
     *           "Lato", "Oswald", or "Playfair Display".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V21\Services\CampaignService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the campaign to enable.
     *
     * Generated from protobuf field <code>string campaign = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * Required. The resource name of the campaign to enable.
     *
     * Generated from protobuf field <code>string campaign = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCampaign($var)
    {
        GPBUtil::checkString($var, True);
        $this->campaign = $var;

        return $this;
    }

    /**
     * Required. The switch to automatically populate top-performing brand assets.
     * This field is required. If true, top-performing brand assets will be
     * automatically populated. If false, the brand_assets field is required.
     *
     * Generated from protobuf field <code>bool auto_populate_brand_assets = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return bool
     */
    public function getAutoPopulateBrandAssets()
    {
        return $this->auto_populate_brand_assets;
    }

    /**
     * Required. The switch to automatically populate top-performing brand assets.
     * This field is required. If true, top-performing brand assets will be
     * automatically populated. If false, the brand_assets field is required.
     *
     * Generated from protobuf field <code>bool auto_populate_brand_assets = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoPopulateBrandAssets($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_populate_brand_assets = $var;

        return $this;
    }

    /**
     * Optional. The brand assets linked to the campaign. This field is required
     * when the value of auto_populate_brand_assets is false.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v21.services.BrandCampaignAssets brand_assets = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V21\Services\BrandCampaignAssets|null
     */
    public function getBrandAssets()
    {
        return $this->brand_assets;
    }

    public function hasBrandAssets()
    {
        return isset($this->brand_assets);
    }

    public function clearBrandAssets()
    {
        unset($this->brand_assets);
    }

    /**
     * Optional. The brand assets linked to the campaign. This field is required
     * when the value of auto_populate_brand_assets is false.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v21.services.BrandCampaignAssets brand_assets = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V21\Services\BrandCampaignAssets $var
     * @return $this
     */
    public function setBrandAssets($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V21\Services\BrandCampaignAssets::class);
        $this->brand_assets = $var;

        return $this;
    }

    /**
     * Optional. The domain of the final uri.
     *
     * Generated from protobuf field <code>string final_uri_domain = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFinalUriDomain()
    {
        return $this->final_uri_domain;
    }

    /**
     * Optional. The domain of the final uri.
     *
     * Generated from protobuf field <code>string final_uri_domain = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFinalUriDomain($var)
    {
        GPBUtil::checkString($var, True);
        $this->final_uri_domain = $var;

        return $this;
    }

    /**
     * Optional. Hex code representation of the main brand color, for example
     * #00ff00. main_color is required when accent color is specified.
     *
     * Generated from protobuf field <code>string main_color = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getMainColor()
    {
        return $this->main_color;
    }

    /**
     * Optional. Hex code representation of the main brand color, for example
     * #00ff00. main_color is required when accent color is specified.
     *
     * Generated from protobuf field <code>string main_color = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setMainColor($var)
    {
        GPBUtil::checkString($var, True);
        $this->main_color = $var;

        return $this;
    }

    /**
     * Optional. Hex code representation of the accent brand color, for example
     * #00ff00. accent_color is required when main_color is specified.
     *
     * Generated from protobuf field <code>string accent_color = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAccentColor()
    {
        return $this->accent_color;
    }

    /**
     * Optional. Hex code representation of the accent brand color, for example
     * #00ff00. accent_color is required when main_color is specified.
     *
     * Generated from protobuf field <code>string accent_color = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAccentColor($var)
    {
        GPBUtil::checkString($var, True);
        $this->accent_color = $var;

        return $this;
    }

    /**
     * Optional. The font family is specified as a string, and must be one of the
     * following: "Open Sans", "Roboto", "Roboto Slab", "Montserrat", "Poppins",
     * "Lato", "Oswald", or "Playfair Display".
     *
     * Generated from protobuf field <code>string font_family = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFontFamily()
    {
        return $this->font_family;
    }

    /**
     * Optional. The font family is specified as a string, and must be one of the
     * following: "Open Sans", "Roboto", "Roboto Slab", "Montserrat", "Poppins",
     * "Lato", "Oswald", or "Playfair Display".
     *
     * Generated from protobuf field <code>string font_family = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFontFamily($var)
    {
        GPBUtil::checkString($var, True);
        $this->font_family = $var;

        return $this;
    }

}

