<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/ads/googleads/v21/services/reach_plan_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Ads\GoogleAds\V21\Services\Client;

use Google\Ads\GoogleAds\Lib\V21\GoogleAdsGapicClientTrait;
use Google\Ads\GoogleAds\V21\Services\GenerateConversionRatesRequest;
use Google\Ads\GoogleAds\V21\Services\GenerateConversionRatesResponse;
use Google\Ads\GoogleAds\V21\Services\GenerateReachForecastRequest;
use Google\Ads\GoogleAds\V21\Services\GenerateReachForecastResponse;
use Google\Ads\GoogleAds\V21\Services\ListPlannableLocationsRequest;
use Google\Ads\GoogleAds\V21\Services\ListPlannableLocationsResponse;
use Google\Ads\GoogleAds\V21\Services\ListPlannableProductsRequest;
use Google\Ads\GoogleAds\V21\Services\ListPlannableProductsResponse;
use Google\Ads\GoogleAds\V21\Services\ListPlannableUserInterestsRequest;
use Google\Ads\GoogleAds\V21\Services\ListPlannableUserInterestsResponse;
use Google\Ads\GoogleAds\V21\Services\ListPlannableUserListsRequest;
use Google\Ads\GoogleAds\V21\Services\ListPlannableUserListsResponse;
use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Reach Plan Service gives users information about audience size that can
 * be reached through advertisement on YouTube. In particular,
 * GenerateReachForecast provides estimated number of people of specified
 * demographics that can be reached by an ad in a given market by a campaign of
 * certain duration with a defined budget.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @method PromiseInterface<GenerateConversionRatesResponse> generateConversionRatesAsync(GenerateConversionRatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GenerateReachForecastResponse> generateReachForecastAsync(GenerateReachForecastRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListPlannableLocationsResponse> listPlannableLocationsAsync(ListPlannableLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListPlannableProductsResponse> listPlannableProductsAsync(ListPlannableProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListPlannableUserInterestsResponse> listPlannableUserInterestsAsync(ListPlannableUserInterestsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListPlannableUserListsResponse> listPlannableUserListsAsync(ListPlannableUserListsRequest $request, array $optionalArgs = [])
 */
class ReachPlanServiceClient
{
    use GapicClientTrait, GoogleAdsGapicClientTrait {
        GoogleAdsGapicClientTrait::modifyClientOptions insteadof GapicClientTrait;
        GoogleAdsGapicClientTrait::modifyUnaryCallable insteadof GapicClientTrait;
        GoogleAdsGapicClientTrait::modifyStreamingCallable insteadof GapicClientTrait;
    }

    /** The name of the service. */
    private const SERVICE_NAME = 'google.ads.googleads.v21.services.ReachPlanService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'googleads.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'googleads.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/adwords',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/reach_plan_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/reach_plan_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/reach_plan_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/reach_plan_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'googleads.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Ads\GoogleAds\V21\Services\ReachPlanServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ReachPlanServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Returns a collection of conversion rate suggestions for supported plannable
     * products.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RequestError]()
     *
     * The async variant is
     * {@see ReachPlanServiceClient::generateConversionRatesAsync()} .
     *
     * @param GenerateConversionRatesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateConversionRatesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateConversionRates(GenerateConversionRatesRequest $request, array $callOptions = []): GenerateConversionRatesResponse
    {
        return $this->startApiCall('GenerateConversionRates', $request, $callOptions)->wait();
    }

    /**
     * Generates a reach forecast for a given targeting / product mix.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [ReachPlanError]()
     * [RequestError]()
     *
     * The async variant is {@see ReachPlanServiceClient::generateReachForecastAsync()}
     * .
     *
     * @param GenerateReachForecastRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateReachForecastResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateReachForecast(GenerateReachForecastRequest $request, array $callOptions = []): GenerateReachForecastResponse
    {
        return $this->startApiCall('GenerateReachForecast', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of plannable locations (for example, countries).
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RequestError]()
     *
     * The async variant is
     * {@see ReachPlanServiceClient::listPlannableLocationsAsync()} .
     *
     * @param ListPlannableLocationsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListPlannableLocationsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPlannableLocations(ListPlannableLocationsRequest $request, array $callOptions = []): ListPlannableLocationsResponse
    {
        return $this->startApiCall('ListPlannableLocations', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of per-location plannable YouTube ad formats with allowed
     * targeting.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RequestError]()
     *
     * The async variant is {@see ReachPlanServiceClient::listPlannableProductsAsync()}
     * .
     *
     * @param ListPlannableProductsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListPlannableProductsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPlannableProducts(ListPlannableProductsRequest $request, array $callOptions = []): ListPlannableProductsResponse
    {
        return $this->startApiCall('ListPlannableProducts', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of plannable user interests.
     * A plannable user interest is one that can be targeted in a reach forecast
     * using
     * [ReachPlanService.GenerateReachForecast][google.ads.googleads.v21.services.ReachPlanService.GenerateReachForecast].
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [ListOperationError]()
     * [QuotaError]()
     * [RequestError]()
     * [StringLengthError]()
     *
     * The async variant is
     * {@see ReachPlanServiceClient::listPlannableUserInterestsAsync()} .
     *
     * @param ListPlannableUserInterestsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListPlannableUserInterestsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPlannableUserInterests(ListPlannableUserInterestsRequest $request, array $callOptions = []): ListPlannableUserInterestsResponse
    {
        return $this->startApiCall('ListPlannableUserInterests', $request, $callOptions)->wait();
    }

    /**
     * Returns the list of plannable user lists with their plannable status.
     * User lists may not be plannable for a number of reasons, including:
     * - They are less than 10 days old.
     * - They have a membership lifespan that is less than 30 days
     * - They have less than 10,000 or more than 700,000 users.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [FieldError]()
     * [HeaderError]()
     * [InternalError]()
     * [QuotaError]()
     * [RangeError]()
     * [ReachPlanError]()
     * [RequestError]()
     *
     * The async variant is
     * {@see ReachPlanServiceClient::listPlannableUserListsAsync()} .
     *
     * @param ListPlannableUserListsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListPlannableUserListsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPlannableUserLists(ListPlannableUserListsRequest $request, array $callOptions = []): ListPlannableUserListsResponse
    {
        return $this->startApiCall('ListPlannableUserLists', $request, $callOptions)->wait();
    }
}
