<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v21/resources/campaign.proto

namespace Google\Ads\GoogleAds\V21\Resources\Campaign;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The setting for Shopping campaigns. Defines the universe of products that
 * can be advertised by the campaign, and how this campaign interacts with
 * other Shopping campaigns.
 *
 * Generated from protobuf message <code>google.ads.googleads.v21.resources.Campaign.ShoppingSetting</code>
 */
class ShoppingSetting extends \Google\Protobuf\Internal\Message
{
    /**
     * ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5;</code>
     */
    protected $merchant_id = null;
    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     */
    protected $feed_label = '';
    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     */
    protected $campaign_priority = null;
    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     */
    protected $enable_local = null;
    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $use_vehicle_inventory = false;
    /**
     * The list of Google Ads accounts IDs of advertising partners cooperating
     * within the campaign.
     * This feature is currently available only for accounts having an
     * advertising partner link. Once set, the field is immutable.
     * This feature is currently supported only for Performance Max, Shopping,
     * Search and Demand Gen campaign types.
     *
     * Generated from protobuf field <code>repeated int64 advertising_partner_ids = 11;</code>
     */
    private $advertising_partner_ids;
    /**
     * Disable the optional product feed. This field is currently supported
     * only for Demand Gen campaigns. See
     * https://support.google.com/google-ads/answer/13721750 to learn more about
     * this feature.
     *
     * Generated from protobuf field <code>optional bool disable_product_feed = 12;</code>
     */
    protected $disable_product_feed = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $merchant_id
     *           ID of the Merchant Center account.
     *           This field is required for create operations. This field is immutable for
     *           Shopping campaigns.
     *     @type string $feed_label
     *           Feed label of products to include in the campaign.
     *           Only one of feed_label or sales_country can be set.
     *           If used instead of sales_country, the feed_label field accepts country
     *           codes in the same format for example: 'XX'.
     *           Otherwise can be any string used for feed label in Google Merchant
     *           Center.
     *     @type int $campaign_priority
     *           Priority of the campaign. Campaigns with numerically higher priorities
     *           take precedence over those with lower priorities.
     *           This field is required for Shopping campaigns, with values between 0 and
     *           2, inclusive.
     *           This field is optional for Smart Shopping campaigns, but must be equal to
     *           3 if set.
     *     @type bool $enable_local
     *           Whether to include local products.
     *     @type bool $use_vehicle_inventory
     *           Immutable. Whether to target Vehicle Listing inventory. This field is
     *           supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     *           inventory in Performance Max campaigns, use `listing_type` instead.
     *     @type array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $advertising_partner_ids
     *           The list of Google Ads accounts IDs of advertising partners cooperating
     *           within the campaign.
     *           This feature is currently available only for accounts having an
     *           advertising partner link. Once set, the field is immutable.
     *           This feature is currently supported only for Performance Max, Shopping,
     *           Search and Demand Gen campaign types.
     *     @type bool $disable_product_feed
     *           Disable the optional product feed. This field is currently supported
     *           only for Demand Gen campaigns. See
     *           https://support.google.com/google-ads/answer/13721750 to learn more about
     *           this feature.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V21\Resources\Campaign::initOnce();
        parent::__construct($data);
    }

    /**
     * ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5;</code>
     * @return int|string
     */
    public function getMerchantId()
    {
        return isset($this->merchant_id) ? $this->merchant_id : 0;
    }

    public function hasMerchantId()
    {
        return isset($this->merchant_id);
    }

    public function clearMerchantId()
    {
        unset($this->merchant_id);
    }

    /**
     * ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMerchantId($var)
    {
        GPBUtil::checkInt64($var);
        $this->merchant_id = $var;

        return $this;
    }

    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return $this->feed_label;
    }

    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     * @return int
     */
    public function getCampaignPriority()
    {
        return isset($this->campaign_priority) ? $this->campaign_priority : 0;
    }

    public function hasCampaignPriority()
    {
        return isset($this->campaign_priority);
    }

    public function clearCampaignPriority()
    {
        unset($this->campaign_priority);
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setCampaignPriority($var)
    {
        GPBUtil::checkInt32($var);
        $this->campaign_priority = $var;

        return $this;
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     * @return bool
     */
    public function getEnableLocal()
    {
        return isset($this->enable_local) ? $this->enable_local : false;
    }

    public function hasEnableLocal()
    {
        return isset($this->enable_local);
    }

    public function clearEnableLocal()
    {
        unset($this->enable_local);
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableLocal($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_local = $var;

        return $this;
    }

    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return bool
     */
    public function getUseVehicleInventory()
    {
        return $this->use_vehicle_inventory;
    }

    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseVehicleInventory($var)
    {
        GPBUtil::checkBool($var);
        $this->use_vehicle_inventory = $var;

        return $this;
    }

    /**
     * The list of Google Ads accounts IDs of advertising partners cooperating
     * within the campaign.
     * This feature is currently available only for accounts having an
     * advertising partner link. Once set, the field is immutable.
     * This feature is currently supported only for Performance Max, Shopping,
     * Search and Demand Gen campaign types.
     *
     * Generated from protobuf field <code>repeated int64 advertising_partner_ids = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdvertisingPartnerIds()
    {
        return $this->advertising_partner_ids;
    }

    /**
     * The list of Google Ads accounts IDs of advertising partners cooperating
     * within the campaign.
     * This feature is currently available only for accounts having an
     * advertising partner link. Once set, the field is immutable.
     * This feature is currently supported only for Performance Max, Shopping,
     * Search and Demand Gen campaign types.
     *
     * Generated from protobuf field <code>repeated int64 advertising_partner_ids = 11;</code>
     * @param array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdvertisingPartnerIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT64);
        $this->advertising_partner_ids = $arr;

        return $this;
    }

    /**
     * Disable the optional product feed. This field is currently supported
     * only for Demand Gen campaigns. See
     * https://support.google.com/google-ads/answer/13721750 to learn more about
     * this feature.
     *
     * Generated from protobuf field <code>optional bool disable_product_feed = 12;</code>
     * @return bool
     */
    public function getDisableProductFeed()
    {
        return isset($this->disable_product_feed) ? $this->disable_product_feed : false;
    }

    public function hasDisableProductFeed()
    {
        return isset($this->disable_product_feed);
    }

    public function clearDisableProductFeed()
    {
        unset($this->disable_product_feed);
    }

    /**
     * Disable the optional product feed. This field is currently supported
     * only for Demand Gen campaigns. See
     * https://support.google.com/google-ads/answer/13721750 to learn more about
     * this feature.
     *
     * Generated from protobuf field <code>optional bool disable_product_feed = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableProductFeed($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_product_feed = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShoppingSetting::class, \Google\Ads\GoogleAds\V21\Resources\Campaign_ShoppingSetting::class);

