<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v21/common/bidding.proto

namespace Google\Ads\GoogleAds\V21\Common;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An automated bidding strategy to help get the most conversion value for your
 * campaigns while spending your budget.
 *
 * Generated from protobuf message <code>google.ads.googleads.v21.common.MaximizeConversionValue</code>
 */
class MaximizeConversionValue extends \Google\Protobuf\Internal\Message
{
    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     */
    protected $target_roas = 0.0;
    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     */
    protected $cpc_bid_ceiling_micros = 0;
    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     */
    protected $cpc_bid_floor_micros = 0;
    /**
     * The percent of ROAS(return on advertising spend) degradation tolerance
     * allowed to increase traffic diversity and conversion volume, specified in
     * millis (for example, 10,000 = 10%). A value of 10,000 means that the
     * advertiser can expect ROAS degradation of up to 10% of the specified target
     * ROAS.
     *
     * Generated from protobuf field <code>optional int64 target_roas_tolerance_percent_millis = 5;</code>
     */
    protected $target_roas_tolerance_percent_millis = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $target_roas
     *           The target return on ad spend (ROAS) option. If set, the bid strategy will
     *           maximize revenue while averaging the target return on ad spend. If the
     *           target ROAS is high, the bid strategy may not be able to spend the full
     *           budget. If the target ROAS is not set, the bid strategy will aim to
     *           achieve the highest possible ROAS for the budget.
     *     @type int|string $cpc_bid_ceiling_micros
     *           Maximum bid limit that can be set by the bid strategy.
     *           The limit applies to all keywords managed by the strategy.
     *           Mutable for portfolio bidding strategies only.
     *     @type int|string $cpc_bid_floor_micros
     *           Minimum bid limit that can be set by the bid strategy.
     *           The limit applies to all keywords managed by the strategy.
     *           Mutable for portfolio bidding strategies only.
     *     @type int|string $target_roas_tolerance_percent_millis
     *           The percent of ROAS(return on advertising spend) degradation tolerance
     *           allowed to increase traffic diversity and conversion volume, specified in
     *           millis (for example, 10,000 = 10%). A value of 10,000 means that the
     *           advertiser can expect ROAS degradation of up to 10% of the specified target
     *           ROAS.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V21\Common\Bidding::initOnce();
        parent::__construct($data);
    }

    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     * @return float
     */
    public function getTargetRoas()
    {
        return $this->target_roas;
    }

    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setTargetRoas($var)
    {
        GPBUtil::checkDouble($var);
        $this->target_roas = $var;

        return $this;
    }

    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     * @return int|string
     */
    public function getCpcBidCeilingMicros()
    {
        return $this->cpc_bid_ceiling_micros;
    }

    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCpcBidCeilingMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->cpc_bid_ceiling_micros = $var;

        return $this;
    }

    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     * @return int|string
     */
    public function getCpcBidFloorMicros()
    {
        return $this->cpc_bid_floor_micros;
    }

    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCpcBidFloorMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->cpc_bid_floor_micros = $var;

        return $this;
    }

    /**
     * The percent of ROAS(return on advertising spend) degradation tolerance
     * allowed to increase traffic diversity and conversion volume, specified in
     * millis (for example, 10,000 = 10%). A value of 10,000 means that the
     * advertiser can expect ROAS degradation of up to 10% of the specified target
     * ROAS.
     *
     * Generated from protobuf field <code>optional int64 target_roas_tolerance_percent_millis = 5;</code>
     * @return int|string
     */
    public function getTargetRoasTolerancePercentMillis()
    {
        return isset($this->target_roas_tolerance_percent_millis) ? $this->target_roas_tolerance_percent_millis : 0;
    }

    public function hasTargetRoasTolerancePercentMillis()
    {
        return isset($this->target_roas_tolerance_percent_millis);
    }

    public function clearTargetRoasTolerancePercentMillis()
    {
        unset($this->target_roas_tolerance_percent_millis);
    }

    /**
     * The percent of ROAS(return on advertising spend) degradation tolerance
     * allowed to increase traffic diversity and conversion volume, specified in
     * millis (for example, 10,000 = 10%). A value of 10,000 means that the
     * advertiser can expect ROAS degradation of up to 10% of the specified target
     * ROAS.
     *
     * Generated from protobuf field <code>optional int64 target_roas_tolerance_percent_millis = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTargetRoasTolerancePercentMillis($var)
    {
        GPBUtil::checkInt64($var);
        $this->target_roas_tolerance_percent_millis = $var;

        return $this;
    }

}

